var samplePageObj = {
  // 샘플 타이틀
  title: '메시지',
  subtitle: '시트 위에 layer popup 형태로 메세지를 보여주는 함수를 알아봅니다.',

  // 샘플 설명
  desc: 'showMessage()와 showMessageTime()함수를 이용하여 시트 위에 표시하고자 하는 메세지를 표시할 수 있습니다.<br>표시된 메세지를 제거할 때는 hideMessage()함수를 사용합니다.',

  // 객체 초기화 구문
  init: {
    Cfg: { SuppressMessage: 0 },
    LeftCols: [
      {
        Header: 'No',
        Name: 'SEQ',
        Type: 'Int',
        Width: 40
      }
    ],
    Cols: [
      {
        Header: '이름',
        Name: 'sName',
        Type: 'Text'
      },
      {
        Header: '급여',
        Name: 'sMoney',
        Type: 'Text',
        MaxWidth: 150
      },
      {
        Header: '전화번호',
        Name: 'sPhone',
        Type: 'Text',
        Width: 150,
        MaxWidth: 300
      },
      {
        Header: '주민/사업자 번호',
        Name: 'sId',
        Type: 'Text'
      },
      {
        Header: '우편번호',
        Name: 'sPostNo',
        Type: 'Text'
      },
      {
        Header: '주소',
        Name: 'sAddr',
        Type: 'Text'
      },
      {
        Header: '카드번호',
        Name: 'sCard',
        Type: 'Text'
      },
      {
        Header: '사용자 임의 포맷',
        Name: 'sCustom',
        Type: 'Text',
        RelWidth: 1
      }
    ]

  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div><strong class=\'mgr30\'>showMessage</strong><hr>'
    + '<label>내용</label> <input id=\'msgval1\' style=\'width:300px;\' class=\'mgr10\' placeholder=\'값을 입력해주세요\' value=\'저장되었습니다.\'/><hr>'
    + '<label>시트 Block 여부</label> <input type=\'checkbox\' id=\'block1\' class=\'mgr10\'><hr>'
    + '<button class=\'mgr10\' onclick=\'sampleBtn(this)\'>메시지 띄우기</button><button class=\'mgr10\' onclick=\'sampleBtn(this)\'>메시지 끄기</button></div>'

    + '<div><strong class=\'mgr30\'>showMessageTime</strong><hr>'
    + '<label>내용</label> <input id=\'msgval\' style=\'width:300px;\' class=\'mgr10\' placeholder=\'값을 입력해주세요\' value=\'작업 중입니다.\n잠시만 기다려 주세요.\'/><hr>'
    + '<label>메시지 지속 시간(초)</label><input id=\'msgtime\' style=\'width:40px;\' class=\'mgr10\' value=\'2\'/><hr>'
    + '<button style=\'\' onclick=\'sampleBtn(this)\'>메시지(Time) 띄우기</button></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },
  // 버튼 클릭시 기능 로직
  action: function () {
    switch (arguments[0].innerText) {
      case '메시지 띄우기':
        sheet.hideMessage(); // 기존에 화면에 다이얼로그가 존재하는 경우 다이얼로그를 닫습니다.
        var msgval1 = document.getElementById('msgval1').value;

        if (!msgval1) {
          alert('메시지를 입력해주세요');

          return;
        }
        sheet.showMessage({
          message: msgval1,
          type: (document.getElementById('block1').checked ? 1 : 0),
          importance: 4
        });
        break;
      case '메시지 끄기':
        sheet.hideMessage();
        break;
      case '메시지(Time) 띄우기':
        sheet.hideMessage(); // 기존에 화면에 다이얼로그가 존재하는 경우 다이얼로그를 닫습니다.
        var msgval = document.getElementById('msgval').value;
        var msgtime = parseInt(document.getElementById('msgtime').value, 10);

        if (!msgval) {
          alert('메시지를 입력해주세요');

          return;
        }
        if (isNaN(msgtime)) {
          alert('메시지 시간을 입력해주세요');

          return;
        }
        msgtime *= 1000;

        sheet.showMessageTime({
          message: msgval,
          time: msgtime,
          importance: 4
        });
        break;
      // no default
    }
  },

  // event구문
  event: {
  },

  // data
  data: [
    {
      sName: '황정열',
      sMoney: '5000',
      sPhone: '01015368874',
      sId: '801221384251',
      sAddr: '서울',
      sPostNo: '137765',
      sCard: '1234123412341234',
      sCustom: '1012220'
    },
    {
      sName: '강대호',
      sMoney: '4700',
      sPhone: '021231234',
      sId: '807151852148',
      sAddr: '경기',
      sPostNo: '142571',
      sCard: '546125847896665',
      sCustom: '675617'
    },
    {
      sName: '김미경',
      sMoney: '3900',
      sPhone: '04321525555',
      sId: '138206820',
      sAddr: '강원',
      sPostNo: '570154',
      sCard: '8547955425411567',
      sCustom: '4180951'
    },
    {
      sName: '김선희',
      sMoney: '3400',
      sPhone: '01011112222',
      sId: '6098204963',
      sAddr: '경기',
      sPostNo: '843521',
      sCard: '1234123412341234',
      sCustom: '321700'
    },
    {
      sName: '최세희',
      sMoney: '3200',
      sPhone: '01674856874',
      sId: '405142384211',
      sAddr: '경기',
      sPostNo: '235552',
      sCard: '4587998856552145',
      sCustom: '2750801'
    },
    {
      sName: '이명희',
      sMoney: '2900',
      sPhone: '0101538874',
      sId: '801221384251',
      sAddr: '서울',
      sPostNo: '615252',
      sCard: '1234123412341234',
      sCustom: '2571901'
    },
    {
      sName: '노효일',
      sMoney: '2300',
      sPhone: '0215368874',
      sId: '506243051223',
      sAddr: '서울',
      sPostNo: '736566',
      sCard: '8585666185411125',
      sCustom: '1520201'
    },
    {
      sName: '원영국',
      sMoney: '2800',
      sPhone: '01075116521',
      sId: '2118204825',
      sAddr: '경기',
      sPostNo: '951137',
      sCard: '7514441556512533',
      sCustom: '2557001'
    },
    {
      sName: '이지선',
      sMoney: '2400',
      sPhone: '025815421',
      sId: '1298261319',
      sAddr: '서울',
      sPostNo: '515426',
      sCard: '6841563125655524',
      sCustom: '2007501'
    },
    {
      sName: '김상도',
      sMoney: '4000',
      sPhone: '0425741245',
      sId: '507142063425',
      sAddr: '경기',
      sPostNo: '751123',
      sCard: '6666555522223333',
      sCustom: '4290851'
    },
    {
      sName: '한보라',
      sMoney: '2800',
      sPhone: '01022116587',
      sId: '2098200597',
      sAddr: '서울',
      sPostNo: '681521',
      sCard: '9999888855552222',
      sCustom: '1959501'
    },
    {
      sName: '장태우',
      sMoney: '2800',
      sPhone: '0557256541',
      sId: '5068272842',
      sAddr: '서울',
      sPostNo: '354112',
      sCard: '3333444455556666',
      sCustom: '1959501'
    },
    {
      sName: '정필석',
      sMoney: '4000',
      sPhone: '0262642080',
      sId: '1298263035',
      sAddr: '경기',
      sPostNo: '846311',
      sCard: '4444222211113255',
      sCustom: '3851201'
    },
    {
      sName: '조성목',
      sMoney: '4100',
      sPhone: '0261254045',
      sId: '410102263574',
      sAddr: '경기',
      sPostNo: '5153655',
      sCard: '5641122315415133',
      sCustom: '6313710'
    },
    {
      sName: '유봉근',
      sMoney: '4200',
      sPhone: '022222222',
      sId: '4098272390',
      sAddr: '서울',
      sPostNo: '412132',
      sCard: '8584154122235565',
      sCustom: '5187601'
    },
    {
      sName: '오필환',
      sMoney: '3700',
      sPhone: '01098415521',
      sId: '2118208651',
      sAddr: '서울',
      sPostNo: '355111',
      sCard: '3554455516545665',
      sCustom: '3412501'
    },
    {
      sName: '송복석',
      sMoney: '3900',
      sPhone: '0435746521',
      sId: '703301678921',
      sAddr: '경기',
      sPostNo: '512321',
      sCard: '5546555111415351',
      sCustom: '3871701'
    },
    {
      sName: '김남연',
      sMoney: '3600',
      sPhone: '0545615477',
      sId: '206232384536',
      sAddr: '서울',
      sPostNo: '154234',
      sCard: '5655154415412335',
      sCustom: '3500701'
    },
    {
      sName: '한혜선',
      sMoney: '2900',
      sPhone: '025555501',
      sId: '1298261319',
      sAddr: '서울',
      sPostNo: '541657',
      sCard: '1234123412341234',
      sCustom: '2746001'
    },
    {
      sName: '조미미',
      sMoney: '2500',
      sPhone: '01065840714',
      sId: '1108264699',
      sAddr: '서울',
      sPostNo: '741351',
      sCard: '5461258478966655',
      sCustom: '2297001'
    },
    {
      sName: '고은혜',
      sMoney: '2600',
      sPhone: '0423522541',
      sId: '1298261207',
      sAddr: '서울',
      sPostNo: '256165',
      sCard: '8547955425411567',
      sCustom: '2390701'
    },
    {
      sName: '성미열',
      sMoney: '2700',
      sPhone: '0335841152',
      sId: '801221384251',
      sAddr: '서울',
      sPostNo: '984561',
      sCard: '1234123412341234',
      sCustom: '2409001'
    },
    {
      sName: '김영중',
      sMoney: '2800',
      sPhone: '0325889885',
      sId: '807151852148',
      sAddr: '인천',
      sPostNo: '137765',
      sCard: '4587998856552145',
      sCustom: '2871101'
    },
    {
      sName: '김기호',
      sMoney: '3800',
      sPhone: '01075116521',
      sId: '138206820',
      sAddr: '서울',
      sPostNo: '561465',
      sCard: '1234123412341234',
      sCustom: '3709801'
    },
    {
      sName: '하태선',
      sMoney: '2800',
      sPhone: '025815421',
      sId: '6098204963',
      sAddr: '서울',
      sPostNo: '846315',
      sCard: '8585666185411125',
      sCustom: '2415001'
    },
    {
      sName: '김정민',
      sMoney: '3200',
      sPhone: '0425741245',
      sId: '405142384211',
      sAddr: '경기',
      sPostNo: '446123',
      sCard: '7514441556512533',
      sCustom: '2989001'
    },
    {
      sName: '장성우',
      sMoney: '3700',
      sPhone: '01022116587',
      sId: '801221384251',
      sAddr: '서울',
      sPostNo: '846311',
      sCard: '6841563125655524',
      sCustom: '3880201'
    },
    {
      sName: '강윤식',
      sMoney: '3500',
      sPhone: '0557256541',
      sId: '506243051223',
      sAddr: '서울',
      sPostNo: '515365',
      sCard: '6666555522223333',
      sCustom: '3855601'
    },
    {
      sName: '김수연',
      sMoney: '3000',
      sPhone: '0262642080',
      sId: '2118204825',
      sAddr: '경기',
      sPostNo: '412132',
      sCard: '9999888855552222',
      sCustom: '2698801'
    },
    {
      sName: '정은지',
      sMoney: '3000',
      sPhone: '0261254045',
      sId: '1298261319',
      sAddr: '서울',
      sPostNo: '355111',
      sCard: '3333444455556666',
      sCustom: '2698801'
    },
    {
      sName: '정창호',
      sMoney: '2700',
      sPhone: '022222222',
      sId: '507142063425',
      sAddr: '서울',
      sPostNo: '512321',
      sCard: '4444222211113255',
      sCustom: '1897501'
    },
    {
      sName: '김대현',
      sMoney: '3300',
      sPhone: '01098415521',
      sId: '2098200597',
      sAddr: '서울',
      sPostNo: '154234',
      sCard: '5641122315415133',
      sCustom: '2709801'
    },
    {
      sName: '안남주',
      sMoney: '3800',
      sPhone: '0435746521',
      sId: '5068272842',
      sAddr: '서울',
      sPostNo: '5416570',
      sCard: '8584154122235565',
      sCustom: '4891410'
    },
    {
      sName: '이민수',
      sMoney: '3800',
      sPhone: '0545615477',
      sId: '1298263035',
      sAddr: '경기',
      sPostNo: '741351',
      sCard: '3554455516545665',
      sCustom: '3845001'
    },
    {
      sName: '최갑석',
      sMoney: '3800',
      sPhone: '025555501',
      sId: '410102263574',
      sAddr: '경기',
      sPostNo: '256165',
      sCard: '5546555111415351',
      sCustom: '3500701'
    },
    {
      sName: '김태헌',
      sMoney: '3700',
      sPhone: '01065840714',
      sId: '4098272390',
      sAddr: '경기',
      sPostNo: '984561',
      sCard: '5655154415412335',
      sCustom: '3489001'
    },
    {
      sName: '박정석',
      sMoney: '3200',
      sPhone: '0423522541',
      sId: '2118208651',
      sAddr: '서울',
      sPostNo: '137765',
      sCard: '9999888855552222',
      sCustom: '2885001'
    },
    {
      sName: '권기윤',
      sMoney: '3700',
      sPhone: '0335841152',
      sId: '703301678921',
      sAddr: '경기',
      sPostNo: '561465',
      sCard: '3333444455556666',
      sCustom: '3450101'
    },
    {
      sName: '김승운',
      sMoney: '3900',
      sPhone: '0325889885',
      sId: '206232384536',
      sAddr: '경기',
      sPostNo: '846315',
      sCard: '4444222211113255',
      sCustom: '3505701'
    },
    {
      sName: '이해영',
      sMoney: '2300',
      sPhone: '01015368874',
      sId: '1298261319',
      sAddr: '경기',
      sPostNo: '446123',
      sCard: '5641122315415133',
      sCustom: '1800801'
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
